var player;
var currentRetries = 0;
const MAX_RETRIES = 3;

$(document).ready(function () {
    // Prevent right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    // Initialize Clappr player
    player = new Clappr.Player({
        source: "http://18.18.18.2/ch1/index.m3u8",
        parentId: "#player",
        width: "100%",
        height: "100%",
        autoPlay: true,
        poster: "well11.png",
        mediacontrol: {seekbar: "#ff0000", buttons: "#ff0000"},
        hlsjsConfig: {
            enableWorker: true,
            lowLatencyMode: true,
            backBufferLength: 90,
            enableSoftwareAES: true,
            manifestLoadingTimeOut: 20000,
            manifestLoadingMaxRetry: 4,
            fragLoadingTimeOut: 20000,
            fragLoadingMaxRetry: 4,
            xhrSetup: function(xhr) {
                xhr.withCredentials = false;
            }
        }
    });

    // Handle player events
    player.on(Clappr.Events.PLAYER_ERROR, function(error) {
        console.log('Player error:', error);
        if (currentRetries < MAX_RETRIES) {
            currentRetries++;
            console.log(`Attempt ${currentRetries} of ${MAX_RETRIES} to recover playback`);
            setTimeout(function() {
                player.configure({
                    source: player.options.source
                });
            }, 2000 * currentRetries);
        } else {
            console.log('Max retries reached');
            currentRetries = 0;
        }
    });

    player.on(Clappr.Events.PLAYER_PLAY, function() {
        currentRetries = 0;
        console.log('Playback started');
    });

    // Channel list display
    $("#vidlink li").css('display', 'none');
    $("#vidlink .Sports").css('display', '');

    $(".channel-list .nav-link").click(function () {
        $(".channel-list .nav-link").removeClass('active');
        $(this).addClass('active');
        var ShowClass = $(this).data('type');
        $("#vidlink li").css('display', 'none');
        $("#vidlink ." + ShowClass).css('display', '');
    });

    // Channel click handling
    $(".channel").click(function () {
        var url = $(this).data('link');
        console.log('Loading channel:', url);
        currentRetries = 0;
        loadVideo(url);
    });
});

function loadVideo(vidURL) {
    if (!vidURL) {
        console.log('No video URL provided');
        return false;
    }

    try {
        console.log('Loading video:', vidURL);
        
        // Update player source
        player.configure({
            source: vidURL,
            autoPlay: true
        });

        return true;
    } catch (error) {
        console.log('Error loading video:', error);
        return false;
    }
}

function ytVidId(url) {
    //var p = /^(?:https?:\/\/)?(?:www\.)?youtube\.com\/watch\?(?=.*v=((\w|-){11}))(?:\S+)?$/;
    //var p = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
    var p = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/;

    if (url.match(p) || getId(url).length == 11)
        return false;
}

/**/
function getId(url) {
    //var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
    var regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=|\?v=)([^#\&\?]*).*/;
    var match = url.match(regExp);

    if (match && match[2].length == 11) {
        return match[2];
    } else {
        return false;
    }
}

var rtmp_suffix = /^rtmp:\/\//;
var hls_suffix = /\.m3u8/;
var mp4_suffix = /\.(mp4|m4p|m4v|mov)/i;
var hds_suffix = /\.f4m/;
var dash_suffix = /\.mpd/;
var flv_suffix = /\.flv/;
var webm_suffix = /\.webm/;
/* AUDIO */
//var mp3_suffix = /\.mp3/;
var mpeg_suffix = /\.(mp3|m4a)/i;
var ogg_suffix = /\.ogg/;

//var youtube_suffix = /\.youtube.com/;
//var yt_suffix = /^(?:https?:\/\/)?(?:www\.)?youtube\.com\/watch\?(?=.*v=((\w|-){11}))(?:\S+)?$/;
var yt_suffix = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;
var dm_suffix = /\.?dailymotion.com/;
var vm_suffix = /\.?vimeo.com/;
/* ADVANCED REGEX */
//      var regVimeo = /^.*(vimeo.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?([0-9]+)/;
//      var regDailymotion = /^.+dailymotion.com\/(video|hub)\/([^_]+)[^#]*(#video=([^_&]+))?/;
//      var regMetacafe = /^.*(metacafe.com)(\/watch\/)(d+)(.*)/i;
//      var youtube_suffix = /(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/;

function getType(url) {

    /* AUDIO */
    if (mpeg_suffix.test(url))
        return 'audio/mpeg';
    if (ogg_suffix.test(url))
        return 'audio/ogg';
    if (dash_suffix.test(url))
        return 'application/dash+xml';
    if (rtmp_suffix.test(url))
        return 'rtmp/mp4';
    if (hls_suffix.test(url))
        return 'application/x-mpegurl';
    if (mp4_suffix.test(url))
        return 'video/mp4';
    if (hds_suffix.test(url))
        return 'application/adobe-f4m';
    if (flv_suffix.test(url))
        return 'video/flv';
    if (webm_suffix.test(url))
        return 'video/webm';
    if (yt_suffix.test(url)) {
        //alert(url.match(yt_suffix)[2]);
        //player.poster(ytmaxres(url.match(yt_suffix)[2]));
        //alert(ytmaxres(url.match(yt_suffix)[2]));
        return 'video/youtube';
    }
    if (dm_suffix.test(url))
        return 'video/dailymotion';
    if (vm_suffix.test(url))
        return 'video/vimeo';

    console.log('could not guess link type: "' + url + '" assuming mp4');
    return 'video/mp4';
}
;

function getExt(ext) {

    //if (ext == "youtube") ext = "mp4";
    if (ext == "mp4" || ext == "m4v")
        ext = "m4v";
    if (ext == "ogg" || ext == "ogv")
        ext = "oga";
    if (ext == "webm")
        ext = "webmv";

    return ext;
}

